<?php
if (!defined('ABSPATH')) {
    exit;
}

$active_tab = $_GET['tab'] ?? 'settings';

// Felder aus DB holen
global $wpdb;
$table_name = $wpdb->prefix . 'wpsc_fields';
$fields = $wpdb->get_results("SELECT * FROM $table_name ORDER BY sort_order ASC", ARRAY_A);

// Brevo Affiliate Link - TODO: Ersetzen sobald verfügbar
$brevo_link = 'https://www.brevo.com/?tap_a=YOUR_AFFILIATE_ID'; // TODO: Affiliate ID einfügen

// Prüfe ob Brevo installiert ist
$brevo_installed = class_exists('Sendinblue') || class_exists('SendinBlue') || function_exists('ws_smtp_mail');
?>

<div class="wrap">
    <h1>⚡ WP Swift Contact</h1>
    
    <p class="description" style="margin-bottom: 20px;">
        <?php _e('Entwickelt von', 'wp-swift-contact'); ?> <strong><a href="https://proleads.online" target="_blank">ProLeads</a></strong> | 
        <a href="https://proleads.online" target="_blank"><?php _e('Weitere Plugins', 'wp-swift-contact'); ?></a>
    </p>
    
    <?php if (!$brevo_installed && $active_tab === 'settings'): ?>
    <!-- BREVO MARKETING BOX - PROMINENT PLATZIERT -->
    <div id="brevo" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; border-radius: 8px; margin: 20px 0 30px 0; box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);">
        <div style="display: flex; align-items: center; gap: 20px;">
            <div style="font-size: 60px;">📧</div>
            <div style="flex: 1;">
                <h2 style="color: white; margin: 0 0 10px 0; font-size: 24px;">
                    <?php _e('Professioneller E-Mail-Versand mit Brevo', 'wp-swift-contact'); ?>
                </h2>
                <p style="margin: 0 0 15px 0; font-size: 16px; opacity: 0.95;">
                    <?php _e('Maximieren Sie Ihre E-Mail-Zustellbarkeit und senden Sie zuverlässig – kostenlos bis 300 E-Mails/Tag', 'wp-swift-contact'); ?>
                </p>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin: 20px 0;">
                    <div>
                        <strong style="display: block; margin-bottom: 5px;">✅ <?php _e('Höchste Zustellrate', 'wp-swift-contact'); ?></strong>
                        <span style="font-size: 14px; opacity: 0.9;"><?php _e('Professionelle E-Mail-Infrastruktur', 'wp-swift-contact'); ?></span>
                    </div>
                    <div>
                        <strong style="display: block; margin-bottom: 5px;">🔒 <?php _e('Spam-Vermeidung', 'wp-swift-contact'); ?></strong>
                        <span style="font-size: 14px; opacity: 0.9;"><?php _e('Authentifizierte Absender, keine Blacklists', 'wp-swift-contact'); ?></span>
                    </div>
                    <div>
                        <strong style="display: block; margin-bottom: 5px;">📊 <?php _e('Echtzeitstatistiken', 'wp-swift-contact'); ?></strong>
                        <span style="font-size: 14px; opacity: 0.9;"><?php _e('Öffnungsraten, Zustellstatus & mehr', 'wp-swift-contact'); ?></span>
                    </div>
                    <div>
                        <strong style="display: block; margin-bottom: 5px;">⚡ <?php _e('Blitzschnell', 'wp-swift-contact'); ?></strong>
                        <span style="font-size: 14px; opacity: 0.9;"><?php _e('E-Mails werden in Sekunden zugestellt', 'wp-swift-contact'); ?></span>
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <a href="<?php echo esc_url($brevo_link); ?>" target="_blank" class="button button-primary button-hero" style="background: white; color: #667eea; border: none; box-shadow: 0 2px 8px rgba(0,0,0,0.15); margin-right: 10px;">
                        🚀 <?php _e('Brevo kostenlos testen', 'wp-swift-contact'); ?>
                    </a>
                    <a href="https://wordpress.org/plugins/mailin/" target="_blank" class="button button-hero" style="background: rgba(255,255,255,0.2); color: white; border: 1px solid rgba(255,255,255,0.3);">
                        <?php _e('WordPress-Plugin installieren', 'wp-swift-contact'); ?>
                    </a>
                </div>
            </div>
        </div>
        
        <div style="margin-top: 25px; padding-top: 25px; border-top: 1px solid rgba(255,255,255,0.2);">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; font-size: 14px;">
                <div>
                    <strong><?php _e('Warum Brevo?', 'wp-swift-contact'); ?></strong><br>
                    <?php _e('Standard-PHP-Mail landet oft im Spam. Brevo garantiert professionelle Zustellung durch dedizierte Mail-Server und Authentifizierung.', 'wp-swift-contact'); ?>
                </div>
                <div>
                    <strong><?php _e('Trusted by 500,000+', 'wp-swift-contact'); ?></strong><br>
                    <?php _e('Über 500.000 Unternehmen weltweit vertrauen auf Brevo. DSGVO-konform, Server in Europa.', 'wp-swift-contact'); ?>
                </div>
                <div>
                    <strong><?php _e('Kostenlos starten', 'wp-swift-contact'); ?></strong><br>
                    <?php _e('300 E-Mails pro Tag dauerhaft kostenlos. Keine Kreditkarte erforderlich. Upgrade jederzeit möglich.', 'wp-swift-contact'); ?>
                </div>
            </div>
        </div>
    </div>
    <?php elseif ($brevo_installed): ?>
    <div class="notice notice-success" style="margin: 20px 0;">
        <p>
            <strong>✅ <?php _e('Brevo ist aktiv!', 'wp-swift-contact'); ?></strong> 
            <?php _e('Ihre E-Mails werden professionell über Brevo versendet.', 'wp-swift-contact'); ?>
        </p>
    </div>
    <?php endif; ?>
    
    <div class="notice notice-info">
        <p>
            <strong><?php _e('Shortcode:', 'wp-swift-contact'); ?></strong> <code>[swiftcontact]</code> 
            <span style="margin: 0 10px;">|</span>
            <strong><?php _e('reCAPTCHA Version:', 'wp-swift-contact'); ?></strong> v3 (<?php _e('unsichtbar, keine Checkbox', 'wp-swift-contact'); ?>)
        </p>
    </div>
    
    <?php if (isset($_GET['updated'])): ?>
        <div class="notice notice-success is-dismissible">
            <p>✅ <?php _e('Einstellungen erfolgreich gespeichert!', 'wp-swift-contact'); ?></p>
        </div>
    <?php endif; ?>
    
    <?php if (isset($_GET['error'])): ?>
        <div class="notice notice-error is-dismissible">
            <p>
                <?php 
                switch($_GET['error']) {
                    case 'exists':
                        _e('❌ Ein Feld mit diesem Namen existiert bereits!', 'wp-swift-contact');
                        break;
                    case 'db_error':
                        _e('❌ Datenbankfehler beim Speichern. Bitte prüfe die Fehlerlogs.', 'wp-swift-contact');
                        break;
                    default:
                        _e('❌ Ein Fehler ist aufgetreten.', 'wp-swift-contact');
                }
                ?>
            </p>
        </div>
    <?php endif; ?>
    
    <h2 class="nav-tab-wrapper">
        <a href="?page=wpsc-settings&tab=settings" class="nav-tab <?php echo $active_tab === 'settings' ? 'nav-tab-active' : ''; ?>">
            ⚙️ <?php _e('Einstellungen', 'wp-swift-contact'); ?>
        </a>
        <a href="?page=wpsc-settings&tab=fields" class="nav-tab <?php echo $active_tab === 'fields' ? 'nav-tab-active' : ''; ?>">
            📋 <?php _e('Felder verwalten', 'wp-swift-contact'); ?>
        </a>
        <a href="?page=wpsc-settings&tab=info" class="nav-tab <?php echo $active_tab === 'info' ? 'nav-tab-active' : ''; ?>">
            ℹ️ <?php _e('Info & Performance', 'wp-swift-contact'); ?>
        </a>
    </h2>
    
    <?php if ($active_tab === 'settings'): ?>
        <form method="post" action="options.php">
            <?php settings_fields('wpsc_settings'); ?>
            
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label><?php _e('Google reCAPTCHA v3 Site Key', 'wp-swift-contact'); ?></label>
                    </th>
                    <td>
                        <input type="text" 
                               name="wpsc_recaptcha_site_key" 
                               value="<?php echo esc_attr(get_option('wpsc_recaptcha_site_key')); ?>" 
                               class="regular-text"
                               placeholder="6LeXXXXXXXXXXXXXXXXXXXXXX">
                        <p class="description">
                            📝 <?php _e('Erhältlich unter:', 'wp-swift-contact'); ?> <a href="https://www.google.com/recaptcha/admin/create" target="_blank">Google reCAPTCHA Admin</a>
                            <br><strong>⚠️ <?php _e('Wichtig:', 'wp-swift-contact'); ?></strong> <?php _e('Nutze', 'wp-swift-contact'); ?> <strong>reCAPTCHA v3</strong> (<?php _e('nicht v2!', 'wp-swift-contact'); ?>)<br>
                            <strong>v3</strong> = <?php _e('Unsichtbar, keine Checkbox', 'wp-swift-contact'); ?> | <strong>v2</strong> = <?php _e('Sichtbare Checkbox', 'wp-swift-contact'); ?>
                        </p>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label for="wpsc_recaptcha_secret"><?php _e('Google reCAPTCHA v3 Secret Key', 'wp-swift-contact'); ?></label>
                    </th>
                    <td>
                        <div style="position: relative; display: inline-block; width: 100%; max-width: 400px;">
                            <input type="password" 
                                   id="wpsc_recaptcha_secret"
                                   name="wpsc_recaptcha_secret" 
                                   value="<?php echo esc_attr(get_option('wpsc_recaptcha_secret')); ?>" 
                                   class="regular-text"
                                   placeholder="6LeXXXXXXXXXXXXXXXXXXXXXX"
                                   style="padding-right: 40px;">
                            <button type="button" 
                                    id="toggle-secret" 
                                    class="button"
                                    style="position: absolute; right: 2px; top: 2px; padding: 4px 8px; min-height: 28px; line-height: 1;"
                                    title="<?php _e('Secret Key anzeigen/verbergen', 'wp-swift-contact'); ?>">
                                <span class="dashicons dashicons-visibility" style="font-size: 16px; width: 16px; height: 16px; line-height: 1;"></span>
                            </button>
                        </div>
                        <p class="description">
                            🔒 <?php _e('Wird nur serverseitig verwendet, nicht im Frontend sichtbar', 'wp-swift-contact'); ?><br>
                            💡 <strong><?php _e('Sicherheit:', 'wp-swift-contact'); ?></strong> <?php _e('Der Secret Key wird in der WordPress-Datenbank gespeichert (Standard-Methode wie bei den meisten Plugins)', 'wp-swift-contact'); ?>
                        </p>
                        
                        <script>
                        document.getElementById('toggle-secret').addEventListener('click', function() {
                            const input = document.getElementById('wpsc_recaptcha_secret');
                            const icon = this.querySelector('.dashicons');
                            
                            if (input.type === 'password') {
                                input.type = 'text';
                                icon.classList.remove('dashicons-visibility');
                                icon.classList.add('dashicons-hidden');
                                this.title = '<?php echo esc_js(__('Secret Key verbergen', 'wp-swift-contact')); ?>';
                            } else {
                                input.type = 'password';
                                icon.classList.remove('dashicons-hidden');
                                icon.classList.add('dashicons-visibility');
                                this.title = '<?php echo esc_js(__('Secret Key anzeigen', 'wp-swift-contact')); ?>';
                            }
                        });
                        </script>
                    </td>
                </tr>
                
                <tr>
                    <th scope="row">
                        <label><?php _e('Empfänger E-Mail', 'wp-swift-contact'); ?></label>
                    </th>
                    <td>
                        <input type="email" 
                               name="wpsc_recipient_email" 
                               value="<?php echo esc_attr(get_option('wpsc_recipient_email', get_option('admin_email'))); ?>" 
                               class="regular-text"
                               placeholder="<?php echo esc_attr(get_option('admin_email')); ?>">
                        <p class="description">
                            📧 <?php _e('E-Mail-Adresse, an die Kontaktanfragen gesendet werden', 'wp-swift-contact'); ?> (<?php _e('Standard: Admin-E-Mail', 'wp-swift-contact'); ?>)<br>
                            <strong><?php _e('E-Mail-Versand:', 'wp-swift-contact'); ?></strong> <?php _e('Nutzt', 'wp-swift-contact'); ?> <code>wp_mail()</code> 
                            <?php if ($brevo_installed): ?>
                                → ✅ <?php _e('Wird automatisch über Brevo versendet', 'wp-swift-contact'); ?>
                            <?php else: ?>
                                → <?php _e('Wird über Standard-PHP-Mail versendet', 'wp-swift-contact'); ?> 
                                (<a href="#brevo"><?php _e('Brevo empfohlen', 'wp-swift-contact'); ?></a>)
                            <?php endif; ?>
                        </p>
                    </td>
                </tr>
            </table>
            
            <?php submit_button(__('Einstellungen speichern', 'wp-swift-contact')); ?>
        </form>
        
        <hr style="margin: 40px 0;">
        
        <h2>🔗 <?php _e('Integration & Verwendung', 'wp-swift-contact'); ?></h2>
        <div style="background: #f9f9f9; padding: 15px; border-radius: 4px;">
            <p><strong><?php _e('Shortcode auf deiner Kontaktseite einfügen:', 'wp-swift-contact'); ?></strong></p>
            <pre style="background: #fff; padding: 15px; border-radius: 4px; font-size: 16px;"><code>[swiftcontact]</code></pre>
            <p class="description"><?php _e('Alternative:', 'wp-swift-contact'); ?> <code>[swift_contact]</code> <?php _e('oder', 'wp-swift-contact'); ?> <code>[kontaktformular]</code> (<?php _e('Legacy', 'wp-swift-contact'); ?>)</p>
        </div>
        
        <h3 style="margin-top: 30px;"><?php _e('Performance-Optimierungen aktiv:', 'wp-swift-contact'); ?></h3>
        <ul style="list-style: disc; margin-left: 20px;">
            <li>✅ <strong><?php _e('Conditional Loading:', 'wp-swift-contact'); ?></strong> <?php _e('reCAPTCHA wird nur auf Seiten mit Shortcode geladen', 'wp-swift-contact'); ?></li>
            <li>✅ <strong><?php _e('Inline Assets:', 'wp-swift-contact'); ?></strong> <?php _e('CSS & JavaScript inline (keine zusätzlichen HTTP-Requests)', 'wp-swift-contact'); ?></li>
            <li>✅ <strong><?php _e('Async reCAPTCHA:', 'wp-swift-contact'); ?></strong> <?php _e('Google reCAPTCHA lädt asynchron mit', 'wp-swift-contact'); ?> <code>async defer</code></li>
            <li>✅ <strong><?php _e('CLS-Optimierung:', 'wp-swift-contact'); ?></strong> <?php _e('Fehlermeldungen haben feste Höhen (verhindert Layout Shift)', 'wp-swift-contact'); ?></li>
            <li>✅ <strong><?php _e('Minimales JavaScript:', 'wp-swift-contact'); ?></strong> <?php _e('Nur ~2KB Vanilla JS (kein jQuery)', 'wp-swift-contact'); ?></li>
            <li>✅ <strong><?php _e('CDN-kompatibel:', 'wp-swift-contact'); ?></strong> <?php _e('Funktioniert mit Bunny.net und allen anderen CDNs', 'wp-swift-contact'); ?></li>
        </ul>
        
        <?php
        // CSP-Hinweis wenn konfiguriert
        $site_key = get_option('wpsc_recaptcha_site_key');
        if (!empty($site_key)):
        ?>
        <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 15px; margin-top: 20px;">
            <h3 style="margin-top: 0;">⚠️ <?php _e('Content Security Policy (CSP) Hinweis', 'wp-swift-contact'); ?></h3>
            <p><?php _e('Falls das Formular nicht lädt oder reCAPTCHA blockiert wird, musst du folgende Domains in deiner CSP erlauben:', 'wp-swift-contact'); ?></p>
            <pre style="background: white; padding: 10px; border-radius: 4px; overflow-x: auto;">script-src 'self' 'unsafe-inline' https://www.google.com https://www.gstatic.com;
frame-src 'self' https://www.google.com;</pre>
            <p><strong><?php _e('Nginx:', 'wp-swift-contact'); ?></strong> <?php _e('Füge diese Direktiven in deiner nginx-Konfiguration hinzu.', 'wp-swift-contact'); ?><br>
            <strong><?php _e('Apache:', 'wp-swift-contact'); ?></strong> <?php _e('Füge dies in deine .htaccess ein:', 'wp-swift-contact'); ?></p>
            <pre style="background: white; padding: 10px; border-radius: 4px; overflow-x: auto;">Header set Content-Security-Policy "script-src 'self' 'unsafe-inline' https://www.google.com https://www.gstatic.com; frame-src 'self' https://www.google.com;"</pre>
        </div>
        <?php endif; ?>
        
    <?php elseif ($active_tab === 'fields'): ?>
        
        <div style="background: white; padding: 20px; margin-top: 20px; border: 1px solid #ccc; border-radius: 4px;">
            <h2>➕ <?php _e('Neues Feld hinzufügen', 'wp-swift-contact'); ?></h2>
            <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
                <input type="hidden" name="action" value="wpsc_save_fields">
                <input type="hidden" name="add_field" value="1">
                <?php wp_nonce_field('wpsc_save_fields'); ?>
                
                <table class="form-table">
                    <tr>
                        <th><label><?php _e('Feldname (technisch)', 'wp-swift-contact'); ?></label></th>
                        <td>
                            <input type="text" name="field_name" required pattern="[a-z_]+" 
                                   title="<?php _e('Nur Kleinbuchstaben und Unterstriche', 'wp-swift-contact'); ?>" 
                                   placeholder="<?php _e('z.B. firma', 'wp-swift-contact'); ?>" 
                                   class="regular-text">
                            <p class="description"><?php _e('Nur Kleinbuchstaben und Unterstriche (z.B. firma, telefon_2)', 'wp-swift-contact'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Feldbezeichnung', 'wp-swift-contact'); ?></label></th>
                        <td>
                            <input type="text" name="field_label" required placeholder="<?php _e('z.B. Firma', 'wp-swift-contact'); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Feldtyp', 'wp-swift-contact'); ?></label></th>
                        <td>
                            <select name="field_type" required class="regular-text">
                                <option value="text"><?php _e('Text', 'wp-swift-contact'); ?></option>
                                <option value="email"><?php _e('E-Mail', 'wp-swift-contact'); ?></option>
                                <option value="tel"><?php _e('Telefon', 'wp-swift-contact'); ?></option>
                                <option value="number"><?php _e('Nummer', 'wp-swift-contact'); ?></option>
                                <option value="textarea"><?php _e('Mehrzeiliger Text', 'wp-swift-contact'); ?></option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Platzhalter', 'wp-swift-contact'); ?></label></th>
                        <td>
                            <input type="text" name="placeholder" placeholder="<?php _e('z.B. Ihre Firma GmbH', 'wp-swift-contact'); ?>" class="regular-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Zeilen (nur Textarea)', 'wp-swift-contact'); ?></label></th>
                        <td>
                            <input type="number" name="field_rows" value="5" min="2" max="20" class="small-text">
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Sortierung', 'wp-swift-contact'); ?></label></th>
                        <td>
                            <input type="number" name="sort_order" value="999" min="0" class="small-text">
                            <p class="description"><?php _e('Kleinere Zahlen erscheinen weiter oben', 'wp-swift-contact'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><label><?php _e('Pflichtfeld', 'wp-swift-contact'); ?></label></th>
                        <td>
                            <label>
                                <input type="checkbox" name="is_required" value="1">
                                <?php _e('Dieses Feld ist erforderlich', 'wp-swift-contact'); ?>
                            </label>
                        </td>
                    </tr>
                </table>
                
                <?php submit_button(__('Feld hinzufügen', 'wp-swift-contact')); ?>
            </form>
        </div>
        
        <h2 style="margin-top: 30px;">📋 <?php _e('Vorhandene Felder', 'wp-swift-contact'); ?></h2>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th style="width: 60px;"><?php _e('Sortierung', 'wp-swift-contact'); ?></th>
                    <th><?php _e('Feldname', 'wp-swift-contact'); ?></th>
                    <th><?php _e('Bezeichnung', 'wp-swift-contact'); ?></th>
                    <th><?php _e('Typ', 'wp-swift-contact'); ?></th>
                    <th style="width: 100px;"><?php _e('Pflichtfeld', 'wp-swift-contact'); ?></th>
                    <th style="width: 100px;"><?php _e('Status', 'wp-swift-contact'); ?></th>
                    <th style="width: 200px;"><?php _e('Aktionen', 'wp-swift-contact'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($fields as $field): ?>
                    <tr>
                        <td><?php echo esc_html($field['sort_order']); ?></td>
                        <td><code><?php echo esc_html($field['field_name']); ?></code></td>
                        <td><strong><?php echo esc_html($field['field_label']); ?></strong></td>
                        <td><?php echo esc_html($field['field_type']); ?></td>
                        <td>
                            <?php if ($field['is_required']): ?>
                                <span style="color: #e74c3c;">● <?php _e('Ja', 'wp-swift-contact'); ?></span>
                            <?php else: ?>
                                <span style="color: #95a5a6;">○ <?php _e('Nein', 'wp-swift-contact'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($field['is_active']): ?>
                                <span style="color: #27ae60;">● <?php _e('Aktiv', 'wp-swift-contact'); ?></span>
                            <?php else: ?>
                                <span style="color: #95a5a6;">● <?php _e('Inaktiv', 'wp-swift-contact'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="display: inline;">
                                <input type="hidden" name="action" value="wpsc_save_fields">
                                <input type="hidden" name="toggle_field" value="1">
                                <input type="hidden" name="field_id" value="<?php echo $field['id']; ?>">
                                <input type="hidden" name="is_active" value="<?php echo $field['is_active'] ? 0 : 1; ?>">
                                <?php wp_nonce_field('wpsc_save_fields'); ?>
                                <button type="submit" class="button button-small">
                                    <?php echo $field['is_active'] ? __('Deaktivieren', 'wp-swift-contact') : __('Aktivieren', 'wp-swift-contact'); ?>
                                </button>
                            </form>
                            
                            <form method="post" action="<?php echo admin_url('admin-post.php'); ?>" style="display: inline;" 
                                  onsubmit="return confirm('<?php echo esc_js(sprintf(__('Feld &quot;%s&quot; wirklich löschen?', 'wp-swift-contact'), $field['field_label'])); ?>');">
                                <input type="hidden" name="action" value="wpsc_save_fields">
                                <input type="hidden" name="delete_field" value="1">
                                <input type="hidden" name="field_id" value="<?php echo $field['id']; ?>">
                                <?php wp_nonce_field('wpsc_save_fields'); ?>
                                <button type="submit" class="button button-small button-link-delete"><?php _e('Löschen', 'wp-swift-contact'); ?></button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
    <?php elseif ($active_tab === 'info'): ?>
        
        <h2>📊 <?php _e('System-Information', 'wp-swift-contact'); ?></h2>
        <table class="widefat" style="max-width: 800px;">
            <tbody>
                <tr>
                    <td style="width: 250px;"><strong><?php _e('Plugin Version:', 'wp-swift-contact'); ?></strong></td>
                    <td><?php echo WPSC_VERSION; ?></td>
                </tr>
                <tr>
                    <td><strong><?php _e('Plugin Entwickler:', 'wp-swift-contact'); ?></strong></td>
                    <td><a href="https://proleads.online" target="_blank">ProLeads</a></td>
                </tr>
                <tr>
                    <td><strong><?php _e('WordPress Version:', 'wp-swift-contact'); ?></strong></td>
                    <td><?php echo get_bloginfo('version'); ?></td>
                </tr>
                <tr>
                    <td><strong><?php _e('PHP Version:', 'wp-swift-contact'); ?></strong></td>
                    <td><?php echo phpversion(); ?></td>
                </tr>
                <tr>
                    <td><strong><?php _e('Aktive Felder:', 'wp-swift-contact'); ?></strong></td>
                    <td>
                        <?php 
                        $active = $wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE is_active = 1");
                        echo $active . ' ' . __('von', 'wp-swift-contact') . ' ' . count($fields);
                        ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php _e('E-Mail-Versand:', 'wp-swift-contact'); ?></strong></td>
                    <td>
                        <?php 
                        if ($brevo_installed) {
                            echo '✅ ' . __('Brevo Plugin erkannt - Professioneller Versand aktiv', 'wp-swift-contact');
                        } else {
                            echo '⚠️ ' . __('Kein E-Mail-Plugin erkannt - Versand über Standard-PHP-Mail', 'wp-swift-contact');
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td><strong><?php _e('cURL verfügbar:', 'wp-swift-contact'); ?></strong></td>
                    <td><?php echo function_exists('curl_init') ? '✅ ' . __('Ja', 'wp-swift-contact') : '❌ ' . __('Nein', 'wp-swift-contact'); ?></td>
                </tr>
                <tr>
                    <td><strong><?php _e('Empfänger E-Mail:', 'wp-swift-contact'); ?></strong></td>
                    <td><?php echo esc_html(get_option('wpsc_recipient_email', get_option('admin_email'))); ?></td>
                </tr>
                <tr>
                    <td><strong><?php _e('reCAPTCHA Version:', 'wp-swift-contact'); ?></strong></td>
                    <td><strong>v3</strong> (<?php _e('unsichtbar, Score-basiert', 'wp-swift-contact'); ?>)</td>
                </tr>
                <tr>
                    <td><strong><?php _e('reCAPTCHA konfiguriert:', 'wp-swift-contact'); ?></strong></td>
                    <td>
                        <?php 
                        $site_key = get_option('wpsc_recaptcha_site_key');
                        $secret = get_option('wpsc_recaptcha_secret');
                        if (!empty($site_key) && !empty($secret)) {
                            echo '✅ ' . __('Ja - reCAPTCHA ist aktiv', 'wp-swift-contact');
                        } else {
                            echo '❌ ' . __('Nein - Bitte unter "Einstellungen" konfigurieren', 'wp-swift-contact');
                        }
                        ?>
                    </td>
                </tr>
            </tbody>
        </table>
        
        <h2 style="margin-top: 40px;">⚡ <?php _e('Performance-Features', 'wp-swift-contact'); ?></h2>
        <div style="background: #f0f9ff; border-left: 4px solid #3498db; padding: 20px; margin: 20px 0;">
            <h3 style="margin-top: 0;"><?php _e('Aktive Optimierungen:', 'wp-swift-contact'); ?></h3>
            <ul style="list-style: disc; margin-left: 20px; line-height: 1.8;">
                <li><strong><?php _e('Conditional Loading:', 'wp-swift-contact'); ?></strong> <?php _e('reCAPTCHA wird nur auf Seiten mit Shortcode geladen', 'wp-swift-contact'); ?></li>
                <li><strong><?php _e('Inline Assets:', 'wp-swift-contact'); ?></strong> <?php _e('CSS & JavaScript werden inline eingebunden (keine HTTP-Requests)', 'wp-swift-contact'); ?></li>
                <li><strong><?php _e('Async reCAPTCHA:', 'wp-swift-contact'); ?></strong> <?php _e('Google reCAPTCHA lädt asynchron mit', 'wp-swift-contact'); ?> <code>async defer</code></li>
                <li><strong><?php _e('CLS-Optimierung:', 'wp-swift-contact'); ?></strong> <?php _e('Fehlermeldungen haben feste Höhen (verhindert Layout Shift)', 'wp-swift-contact'); ?></li>
                <li><strong><?php _e('Minimales JavaScript:', 'wp-swift-contact'); ?></strong> <?php _e('Nur ~2KB Vanilla JS (kein jQuery nötig)', 'wp-swift-contact'); ?></li>
                <li><strong><?php _e('CDN-kompatibel:', 'wp-swift-contact'); ?></strong> <?php _e('Funktioniert mit Bunny.net und allen anderen CDNs', 'wp-swift-contact'); ?></li>
                <li><strong><?php _e('Caching-freundlich:', 'wp-swift-contact'); ?></strong> <?php _e('Statisches HTML, keine blockierenden Skripte', 'wp-swift-contact'); ?></li>
                <li><strong><?php _e('CSP-kompatibel:', 'wp-swift-contact'); ?></strong> <?php _e('Keine external Fonts oder Scripts (außer reCAPTCHA)', 'wp-swift-contact'); ?></li>
            </ul>
        </div>
        
        <h2 style="margin-top: 40px;">🎯 Core Web Vitals</h2>
        <table class="widefat" style="max-width: 800px;">
            <thead>
                <tr>
                    <th><?php _e('Metrik', 'wp-swift-contact'); ?></th>
                    <th><?php _e('Optimierung', 'wp-swift-contact'); ?></th>
                    <th style="width: 100px; text-align: center;"><?php _e('Status', 'wp-swift-contact'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><strong>LCP (Largest Contentful Paint)</strong></td>
                    <td><?php _e('Inline CSS, keine blockierenden Skripte', 'wp-swift-contact'); ?></td>
                    <td style="text-align: center; color: #27ae60;">✓ <?php _e('Optimiert', 'wp-swift-contact'); ?></td>
                </tr>
                <tr>
                    <td><strong>CLS (Cumulative Layout Shift)</strong></td>
                    <td><?php _e('Feste Höhen für Fehlermeldungen, reservierter Platz', 'wp-swift-contact'); ?></td>
                    <td style="text-align: center; color: #27ae60;">✓ <?php _e('Optimiert', 'wp-swift-contact'); ?></td>
                </tr>
                <tr>
                    <td><strong>FID/INP (Interaktivität)</strong></td>
                    <td><?php _e('Minimales JavaScript, async Loading', 'wp-swift-contact'); ?></td>
                    <td style="text-align: center; color: #27ae60;">✓ <?php _e('Optimiert', 'wp-swift-contact'); ?></td>
                </tr>
            </tbody>
        </table>
        
        <h2 style="margin-top: 40px;">📝 <?php _e('Shortcode-Verwendung', 'wp-swift-contact'); ?></h2>
        <div style="background: #f9f9f9; padding: 20px; border-radius: 4px;">
            <p><?php _e('Füge diesen Shortcode auf deiner Kontaktseite ein:', 'wp-swift-contact'); ?></p>
            <pre style="background: #fff; padding: 15px; border-radius: 4px; font-size: 16px;"><code>[swiftcontact]</code></pre>
            <p class="description"><?php _e('Alternative:', 'wp-swift-contact'); ?> <code>[swift_contact]</code> <?php _e('oder', 'wp-swift-contact'); ?> <code>[kontaktformular]</code></p>
        </div>
        
        <h2 style="margin-top: 40px;">🆘 Support</h2>
        <div style="background: #fff; border: 1px solid #ddd; padding: 20px; border-radius: 4px;">
            <p><strong><?php _e('Bei Problemen oder Fragen:', 'wp-swift-contact'); ?></strong></p>
            <ul style="list-style: disc; margin-left: 20px;">
                <li>🌐 Website: <a href="https://proleads.online" target="_blank">proleads.online</a></li>
                <li>📧 E-Mail: Kontaktformular auf proleads.online</li>
            </ul>
        </div>
        
    <?php endif; ?>
</div>

<style>
.nav-tab-wrapper {
    margin-bottom: 0;
}
.form-table th {
    padding: 20px 10px 20px 0;
}
.button-link-delete {
    color: #b32d2e;
}
.button-link-delete:hover {
    color: #dc3232;
}
</style>
