# ⚡ WP Swift Contact - WordPress Plugin

**Version:** 1.0.3  
**Entwickler:** [ProLeads](https://proleads.online)  
**Plugin-Website:** [proleads.online](https://proleads.online)

Ein leichtgewichtiges, aber vollwertiges Kontaktformular-Plugin für WordPress mit Google reCAPTCHA v3.

---

## 🎯 Warum "Swift"?

**Swift** = Schnell, flink, wendig - aber **nicht** "light" (was nach "fehlen Features" klingt)

✅ Leichtgewichtig (nur ~5KB)  
✅ Vollwertig (alle wichtigen Features)  
✅ Performance-optimiert  
✅ Mehrsprachig (DE, FR, ES, EN)

---

## 📦 Installation

### Schnellstart (5 Minuten)

1. **ZIP hochladen:** WordPress Admin → Plugins → Installieren → Plugin hochladen
2. **Aktivieren:** Plugin aktivieren
3. **reCAPTCHA Keys:** https://www.google.com/recaptcha/admin/create (v3!)
4. **Konfigurieren:** Einstellungen → WP Swift Contact
5. **Shortcode:** `[swiftcontact]` auf Kontaktseite einfügen

**Fertig!** 🎉

---

## 🔧 CSP (Content Security Policy) Problem LÖSEN

### Problem: Formular lädt nicht / reCAPTCHA blockiert

**Ursache:** Deine Website hat strenge CSP-Einstellungen, die `google.com` und `gstatic.com` blockieren.

### ✅ Lösung für nginx

Öffne deine nginx-Konfiguration und füge hinzu:

```nginx
# In deinem server {} Block oder location {} Block
add_header Content-Security-Policy "
    default-src 'self';
    script-src 'self' 'unsafe-inline' https://www.google.com https://www.gstatic.com;
    frame-src 'self' https://www.google.com;
    style-src 'self' 'unsafe-inline';
    font-src 'self' data:;
" always;
```

**Oder minimal (nur für reCAPTCHA):**

```nginx
add_header Content-Security-Policy "
    script-src 'self' 'unsafe-inline' https://www.google.com https://www.gstatic.com;
    frame-src 'self' https://www.google.com;
" always;
```

Nach Änderung:
```bash
sudo nginx -t
sudo systemctl reload nginx
```

### ✅ Lösung für Apache (.htaccess)

```apache
<IfModule mod_headers.c>
    Header set Content-Security-Policy "script-src 'self' 'unsafe-inline' https://www.google.com https://www.gstatic.com; frame-src 'self' https://www.google.com;"
</IfModule>
```

### ✅ Test ob es funktioniert

1. Öffne deine Kontaktseite
2. Öffne Browser-Konsole (F12)
3. Aktualisiere die Seite
4. Keine CSP-Fehler mehr? ✓ Funktioniert!

---

## 🚀 Features

### Performance

- ✅ **Conditional Loading:** reCAPTCHA nur auf Seiten mit Shortcode
- ✅ **Inline Assets:** CSS & JS inline (0 extra HTTP-Requests)
- ✅ **~5KB Gesamtgröße** (vs ~400KB Gravity Forms)
- ✅ **Core Web Vitals optimiert** (LCP, CLS, FID/INP)
- ✅ **Bunny.net CDN-kompatibel**

### Funktionen

- ✅ **reCAPTCHA v3** (unsichtbar, keine Checkbox)
- ✅ **Mehrsprachig** (DE, FR, ES, EN)
- ✅ **Admin-Interface** zum Felder verwalten
- ✅ **Pflichtfelder** markierbar
- ✅ **Brevo-Integration** (automatisch via `wp_mail()`)
- ✅ **Secret Key Toggle** (Sicherheit)

### Sicherheit

- ✅ reCAPTCHA v3 Bot-Schutz (Score >= 0.5)
- ✅ CSRF-Schutz (WordPress Nonces)
- ✅ XSS-Schutz (Escaping)
- ✅ SQL Injection-Schutz (Prepared Statements)
- ✅ Input-Validierung

---

## 📧 Brevo Integration

### Warum Brevo? (ehemals Sendinblue)

**Das Plugin nutzt `wp_mail()` - wenn du Brevo installierst, werden E-Mails automatisch über Brevo versendet!**

#### Vorteile:

1. **🎯 Höchste Zustellrate**
   - Professionelle E-Mail-Infrastruktur (API/SMTP)
   - Keine Blacklists
   - Authentifizierte Absender

2. **🔒 Spam-Vermeidung**
   - E-Mails landen NICHT im Spam
   - SPF, DKIM, DMARC konfiguriert
   - Trusted by 500.000+ Unternehmen

3. **📊 Statistiken**
   - Öffnungsraten
   - Klickraten
   - Zustellstatus in Echtzeit

4. **💰 Kostenlos**
   - 300 E-Mails/Tag gratis
   - Keine Kreditkarte nötig
   - DSGVO-konform, Server in Europa

### Installation:

1. **WordPress Plugin:** https://wordpress.org/plugins/mailin/
2. **Brevo Account:** https://www.brevo.com/ (kostenlos)
3. **API-Key eintragen:** Brevo Plugin-Einstellungen
4. **Fertig!** E-Mails werden automatisch über Brevo versendet

---

## 🌍 Mehrsprachigkeit

### Unterstützte Sprachen

- 🇩🇪 **Deutsch** (DE)
- 🇬🇧 **Englisch** (EN) 
- 🇫🇷 **Französisch** (FR)
- 🇪🇸 **Spanisch** (ES)

### Wie funktioniert's?

Das Plugin erkennt automatisch die WordPress-Sprache und zeigt Texte in der entsprechenden Sprache an.

**Sprache ändern:**
WordPress Admin → Einstellungen → Allgemein → Sprache der Website

### Eigene Übersetzungen

1. Installiere Plugin wie **Loco Translate**
2. Gehe zu: Loco Translate → Plugins → WP Swift Contact
3. Erstelle neue Übersetzung oder bearbeite vorhandene

---

## 📝 Shortcode-Verwendung

### Standard:
```
[swiftcontact]
```

### Alternativ:
```
[swift_contact]
```

### Legacy (für Umstieg von anderem Plugin):
```
[kontaktformular]
```

Alle funktionieren identisch!

---

## 🎛️ Admin-Interface

**Einstellungen → WP Swift Contact**

### Tab 1: Einstellungen

- **reCAPTCHA Keys** (mit Secret Key Toggle 👁️)
- **Empfänger E-Mail**
- **Brevo Marketing Box** (prominent platziert)
- **CSP-Hinweise**

### Tab 2: Felder verwalten

- ✅ Neue Felder hinzufügen
- ✅ **Pflichtfelder** markieren
- ✅ Sortierung ändern
- ✅ Felder aktivieren/deaktivieren
- ✅ Felder löschen

**Standard-Felder:**
- Name *(Pflichtfeld)*
- E-Mail *(Pflichtfeld)*
- Telefon
- Betreff *(Pflichtfeld)*
- Nachricht *(Pflichtfeld)*

### Tab 3: Info & Performance

- System-Status
- Performance-Metriken
- Core Web Vitals
- Support-Links

---

## 🔍 Problem: Formular lädt nicht

### Symptom

Du siehst nur den Button "Nachricht senden", aber keine Eingabefelder.

### Mögliche Ursachen & Lösungen

#### 1. CSP blockiert JavaScript

**Lösung:** Siehe Abschnitt "CSP Problem LÖSEN" oben

#### 2. Keine Felder in Datenbank

**Prüfen:**
1. Gehe zu: Einstellungen → WP Swift Contact → Felder verwalten
2. Siehst du Felder in der Liste?
3. Sind sie **aktiv** (grüner Punkt)?

**Lösung:** Plugin deaktivieren und neu aktivieren (erstellt Standard-Felder)

#### 3. JavaScript-Konflikt mit anderem Plugin

**Prüfen:**
1. Öffne Browser-Konsole (F12) → Console
2. Siehst du Fehlermeldungen?

**Lösung:** Andere Plugins nacheinander deaktivieren und testen

#### 4. Theme-Konflikt

**Testen:**
1. Wechsle vorübergehend zu Twenty Twenty-Four Theme
2. Funktioniert es jetzt? → Theme-Problem

**Lösung:** Theme-Entwickler kontaktieren

---

## ⚠️ Häufige Probleme

### E-Mails kommen nicht an

**Lösungen:**
1. ✅ Installiere Brevo Plugin (empfohlen!)
2. ✅ Prüfe Spam-Ordner
3. ✅ Teste mit anderer E-Mail-Adresse
4. ✅ Aktiviere Debug: `define('WP_DEBUG_LOG', true);` in `wp-config.php`

### reCAPTCHA funktioniert nicht

**Lösungen:**
1. ✅ Stelle sicher, dass du **v3** (nicht v2!) verwendest
2. ✅ Prüfe ob Keys korrekt sind (nicht vertauscht)
3. ✅ Prüfe ob Domain in reCAPTCHA registriert ist
4. ✅ Löse CSP-Problem (siehe oben)

### Formular wird nicht angezeigt

**Lösungen:**
1. ✅ Plugin aktiviert?
2. ✅ Shortcode richtig? `[swiftcontact]`
3. ✅ Felder in DB vorhanden und aktiv?
4. ✅ Browser-Konsole (F12) auf Fehler prüfen
5. ✅ CSP-Problem? (siehe oben)

---

## 📊 Technische Details

### Datenbank

Erstellt Tabelle: `wp_wpsc_fields`

```sql
CREATE TABLE wp_wpsc_fields (
    id bigint(20) AUTO_INCREMENT PRIMARY KEY,
    field_name varchar(50) NOT NULL UNIQUE,
    field_label varchar(100) NOT NULL,
    field_type varchar(20) NOT NULL,
    is_required tinyint(1) DEFAULT 0,
    placeholder varchar(255),
    field_rows int(3) DEFAULT 5,
    sort_order int(5) DEFAULT 0,
    is_active tinyint(1) DEFAULT 1,
    created_at datetime DEFAULT CURRENT_TIMESTAMP
);
```

### Einstellungen (wp_options)

- `wpsc_recaptcha_site_key`
- `wpsc_recaptcha_secret`
- `wpsc_recipient_email`

**Hinweis:** Nicht verschlüsselt (WordPress-Standard)

### E-Mail-Versand

1. Formular wird abgeschickt
2. Plugin validiert Eingaben
3. reCAPTCHA Score wird geprüft (>= 0.5)
4. E-Mail wird mit `wp_mail()` versendet
5. Brevo Plugin (falls installiert) fängt `wp_mail()` ab
6. E-Mail wird über Brevo API versendet

**Ohne Brevo:** Versand über Standard-PHP-Mail oder SMTP

---

## 🎨 Styling anpassen

### Option 1: Eigenes CSS (empfohlen)

In deinem Theme CSS:

```css
/* Formular breiter */
.wpsc-form {
    max-width: 800px;
}

/* Button-Farbe ändern */
.wpsc-submit {
    background: #ff6b6b;
}

.wpsc-submit:hover {
    background: #ee5a5a;
}

/* Eingabefelder runder */
.wpsc-form input,
.wpsc-form textarea {
    border-radius: 8px;
}
```

### Option 2: Plugin-Code ändern

In `/wp-content/plugins/wp-swift-contact/assets/style.css`

---

## 🔄 Affiliate Link eintragen

**Für Brevo Affiliate Programm:**

1. Öffne: `/wp-content/plugins/wp-swift-contact/admin/settings-page.php`
2. Zeile 10:
```php
$brevo_link = 'https://www.brevo.com/?tap_a=DEINE_AFFILIATE_ID';
```
3. Ersetze `YOUR_AFFILIATE_ID` mit deiner echten ID
4. Speichern

Der Link wird dann im Admin-Interface prominent angezeigt.

---

## 📞 Support

**Website:** https://proleads.online  
**Website:** https://proleads.online  
**Support:** Kontaktformular auf proleads.online

---

## 🔐 Sicherheit & Datenschutz

### Secret Key Speicherung

**Frage:** Werden die Keys verschlüsselt gespeichert?  
**Antwort:** Nein - das ist WordPress-Standard.

**Warum?**
- WordPress speichert Plugin-Einstellungen unverschlüsselt in `wp_options`
- Das machen auch WooCommerce, Contact Form 7, etc.
- Datenbank ist durch .htaccess geschützt
- Nur Admins haben Zugriff
- Secret Key wird nur serverseitig verwendet

**Empfohlene Sicherheitsmaßnahmen:**
- ✅ Sichere Datenbank-Passwörter
- ✅ HTTPS nutzen
- ✅ WordPress aktuell halten
- ✅ Starke Admin-Passwörter
- ✅ 2FA für Admin-Accounts

---

## 📄 Lizenz

GPL v2 or later - Frei verwendbar für private und kommerzielle Projekte.

---

## 🙏 Credits

Entwickelt von **ProLeads**  
Optimiert für Performance, Core Web Vitals und moderne WordPress-Standards

**Viel Erfolg mit WP Swift Contact!** 🚀
